/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.HSCSendSignalClt;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PISystemConnectionCreate {
    private static final int NUM_VALID_PARMS = 4;
    private String _ipAddress;
    private String _passwd;
    private String _ignorePasswd;
    private String _autoDiscovery;
    private String m_resourceType;
    private PrintStream _out;
    private boolean _writeStatus;
    private HashMap _validParms = new HashMap(9, 0.5f);
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";

    private PISystemConnectionCreate(PrintStream printStream, boolean bl) {
        this._out = printStream;
        this._writeStatus = bl;
        this._validParms.put("--ip", null);
        this._validParms.put("--passwd", null);
        this._validParms.put("--ignorepasswd", null);
        this._validParms.put("-r", null);
        this._validParms.put("-o", null);
    }

    private void doConnectionCreate() throws PIHscClientException {
        HSCSendSignalClt hSCSendSignalClt = HSCSendSignalClt.getInstance(null, null);
        int n = 221;
        int n2 = -1;
        int n3 = 1;
        n3 = this._ignorePasswd == null ? 3 : 2;
        Vector<String> vector = new Vector<String>(n3);
        vector.addElement(this._ipAddress);
        if (this._ignorePasswd == null) {
            vector.addElement(this._passwd);
        }
        if ("sys".equals(this.m_resourceType)) {
            n2 = 0;
        } else if ("frame".equals(this.m_resourceType)) {
            n2 = 1;
        }
        vector.addElement(Integer.toString(n2));
        String string = HscPasswordMgr.getHscUser();
        String string2 = HscPasswordMgr.getCredentialKey(string);
        try {
            int n4 = hSCSendSignalClt.sendSignal(n, vector, string, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void purgeRemoveFile() {
        File file = new File("/opt/hsc/data/.hmc/", ".removed");
        if (file.exists()) {
            EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -rf " + "/opt/hsc/data/.hmc/.removed"));
        }
    }

    private void performCommand() throws PIHscClientException {
        if (this._autoDiscovery != null) {
            this.purgeRemoveFile();
            return;
        }
        this.checkParameters();
        this.doConnectionCreate();
        if (this._writeStatus) {
            this._writeStatus = false;
            this._out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        if (this._ipAddress == null || this._ipAddress.length() < 1) {
            String[] stringArray = new String[]{"--ip"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this._passwd != null && this._passwd.length() < 1) {
            String[] stringArray = new String[]{"--passwd"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_resourceType == null) {
            this.m_resourceType = "sys";
        } else if (!"sys".equals(this.m_resourceType) && !"frame".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", new String[]{"-r"}, null);
        }
        if (this._passwd == null && this._ignorePasswd == null) {
            this.promptForPasswd();
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_resourceType = (String)hashMap.get("-r");
        this._ipAddress = (String)hashMap.get("--ip");
        this._passwd = (String)hashMap.get("--passwd");
        this._ignorePasswd = (String)hashMap.get("--ignorepasswd");
        this._autoDiscovery = (String)hashMap.get("-o");
        if (this._autoDiscovery != null) {
            if (this._autoDiscovery.equals("auto")) {
                return;
            }
            String[] stringArray = new String[]{"-o " + this._autoDiscovery};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM", stringArray, null);
        }
        if (this._passwd != null && this._ignorePasswd != null) {
            String[] stringArray = new String[]{"--passwd, --ignorepasswd"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
    }

    private void promptForPasswd() {
        try {
            EExecResult eExecResult;
            String string = System.getProperty("HMCtty.name");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (string != null && string != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string));
                string2 = "stty --file=" + string + " " + eExecResult.stdout;
                string3 = "stty --file=" + string + " -echo";
                bl = true;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "ENTER_HMC_ACCESS_PASSWORD"));
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            this._passwd = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "MKSYSCONN_HELP_GA3"));
    }

    public static int callCommandFromRouter(Object object, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemConnectionCreate pISystemConnectionCreate = new PISystemConnectionCreate(printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemConnectionCreate._validParms);
            pISystemConnectionCreate.mapParameters(hashMap);
            pISystemConnectionCreate.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

